<?php
function custom_menu_item_user_role_field($item_id, $item, $depth, $args) {
    $roles = wp_roles()->get_names();
    $selected_roles = get_post_meta($item_id, '_menu_item_user_roles', true);
    $selected_roles = is_array($selected_roles) ? $selected_roles : [];

    echo '<p class="description description-wide">';
    echo '<label for="edit-menu-item-user-roles-' . $item_id . '"><strong>Visible for roles:</strong></label><br>';

    // Special options
    $special_options = [
        'logged-in' => 'Logged-in users',
        'logged-out' => 'Logged-out users',
    ];

    foreach ($special_options as $key => $label) {
        $checked = in_array($key, $selected_roles) ? 'checked' : '';
        echo '<input type="checkbox" name="menu-item-user-roles[' . $item_id . '][]" value="' . esc_attr($key) . '" ' . $checked . '> ' . esc_html($label) . '<br>';
    }

    // User roles
    foreach ($roles as $role_key => $role_name) {
        $checked = in_array($role_key, $selected_roles) ? 'checked' : '';
        echo '<input type="checkbox" name="menu-item-user-roles[' . $item_id . '][]" value="' . esc_attr($role_key) . '" ' . $checked . '> ' . esc_html($role_name) . '<br>';
    }

    echo '</p>';
}
add_action('wp_nav_menu_item_custom_fields', 'custom_menu_item_user_role_field', 10, 4);


function save_menu_item_user_roles($menu_id, $menu_item_db_id) {
    if (isset($_POST['menu-item-user-roles'][$menu_item_db_id])) {
        update_post_meta(
            $menu_item_db_id,
            '_menu_item_user_roles',
            array_map('sanitize_text_field', $_POST['menu-item-user-roles'][$menu_item_db_id])
        );
    } else {
        delete_post_meta($menu_item_db_id, '_menu_item_user_roles');
    }
}
add_action('wp_update_nav_menu_item', 'save_menu_item_user_roles', 10, 2);

function filter_menu_items_by_user_role($items, $args) {
    foreach ($items as $key => $item) {
        $roles = get_post_meta($item->ID, '_menu_item_user_roles', true);

        if (!empty($roles)) {
            if (!is_user_logged_in()) {
                unset($items[$key]); // User not logged in, remove item with role restrictions
                continue;
            }

            $user = wp_get_current_user();
            $user_roles = (array) $user->roles;
            $allowed = array_intersect($roles, $user_roles);

            if (empty($allowed)) {
                unset($items[$key]); // User role not in allowed list
            }
        }
    }

    return $items;
}
add_filter('wp_get_nav_menu_items', 'filter_menu_items_by_user_role', 10, 2);


?>