<?php

// Dodaj novi tab u My Account meni
add_filter('woocommerce_account_menu_items', 'dodaj_moj_profil_tab', 5);
function dodaj_moj_profil_tab($items) {
    // Dodaj novi link npr. pre odjave
    $items['hosting-info'] = 'Hosting Info';
    return $items;
}

// Registruj novi endpoint
add_action('init', 'registruj_hosting_info_endpoint');
function registruj_hosting_info_endpoint() {
    add_rewrite_endpoint('hosting-info', EP_ROOT | EP_PAGES);
}

// Dodaj sadržaj stranice
add_action('woocommerce_account_hosting-info_endpoint', 'prikazi_moj_profil_sadrzaj');
function prikazi_moj_profil_sadrzaj() {
    echo '<h3 class="ticket-h3">Hosting Info</h3>';
    echo '<p>Here you can add or edit your hosting info for the website.</p>';
}

// Ključ za enkripciju (promeni ovo i čuvaj ga na sigurnom!)
define('MY_SECRET_KEY', 'ggpp');
define('MY_SECRET_IV', 'ggwp');

function encrypt_password($password) {
    return openssl_encrypt($password, 'aes-256-cbc', MY_SECRET_KEY, 0, MY_SECRET_IV);
}

function decrypt_password($encrypted) {
    return openssl_decrypt($encrypted, 'aes-256-cbc', MY_SECRET_KEY, 0, MY_SECRET_IV);
}

// Prikaži formu u Moj Profil tabu
add_action('woocommerce_account_hosting-info_endpoint', 'prikazi_moj_profil_formu');
function prikazi_moj_profil_formu() {
    $user_id = get_current_user_id();
    $url = get_user_meta($user_id, 'custom_url', true);
    $user = get_user_meta($user_id, 'custom_user', true);
    $encrypted_pass = get_user_meta($user_id, 'custom_pass', true);
    $decrypted_pass = $encrypted_pass ? decrypt_password($encrypted_pass) : '';

    ?>
    <form method="post">
         <?php
    $admin_note = get_user_meta($user_id, 'admin_note', true);
    if ($admin_note) {
         echo '<h4 class="admin-notes-h4">Admin Notes:</h4>';
        echo '<div class="admin-notes-box">' . nl2br(esc_html($admin_note)) . '</div>';
    }
    ?>
         <p>
            <label for="custom_url">Hosting Provider URL:</label><br>
            <input type="url" name="custom_url" id="custom_url" value="<?php echo esc_attr($url); ?>">
        </p>
        <p>
            <label for="custom_user">Username/Email/Customer ID:</label><br>
            <input type="text" name="custom_user" id="custom_user" value="<?php echo esc_attr($user); ?>">
        </p>
        <p>
            <label for="custom_pass">Password:</label><br>
            <input type="password" name="custom_pass" id="custom_pass" value="<?php echo esc_attr($decrypted_pass); ?>">
            <button type="button" onclick="togglePassword()" class="show-pass">Show</button>
        </p>
        <p>
            <button type="submit" name="save_custom_data" class="ticket-button">Save</button>
        </p>
    </form>

    <script>
        function togglePassword() {
            var passInput = document.getElementById('custom_pass');
            if (passInput.type === "password") {
                passInput.type = "text";
            } else {
                passInput.type = "password";
            }
        }
    </script>
    <?php
    
}

// Snimi podatke kada korisnik pošalje formu
add_action('template_redirect', 'sacuvaj_custom_user_podatke');
function sacuvaj_custom_user_podatke() {
    if (isset($_POST['save_custom_data']) && is_user_logged_in()) {
        $user_id = get_current_user_id();

        if (!empty($_POST['custom_url'])) {
            update_user_meta($user_id, 'custom_url', sanitize_text_field($_POST['custom_url']));
        }

        if (!empty($_POST['custom_user'])) {
            update_user_meta($user_id, 'custom_user', sanitize_text_field($_POST['custom_user']));
        }

        if (!empty($_POST['custom_pass'])) {
            $encrypted = encrypt_password(sanitize_text_field($_POST['custom_pass']));
            update_user_meta($user_id, 'custom_pass', $encrypted);
        }
    }
}




// Dodaj polje u admin profil korisnika
add_action('show_user_profile', 'admin_dodatno_polje');
add_action('edit_user_profile', 'admin_dodatno_polje');

function admin_dodatno_polje($user) {
    if (!current_user_can('administrator')) return;
    $admin_note = get_user_meta($user->ID, 'admin_note', true);
    ?>
    <h3>Admin Polje</h3>
    <table class="form-table">
        <tr>
            <th><label for="admin_note">Napomena za korisnika</label></th>
            <td>
                <textarea name="admin_note" id="admin_note" rows="5" style="width:100%;"><?php echo esc_textarea($admin_note); ?></textarea>
            </td>
        </tr>
    </table>
    <?php
}

// Snimi admin polje
add_action('personal_options_update', 'sacuvaj_admin_polje');
add_action('edit_user_profile_update', 'sacuvaj_admin_polje');

function sacuvaj_admin_polje($user_id) {
    if (!current_user_can('administrator')) return;
    if (isset($_POST['admin_note'])) {
        update_user_meta($user_id, 'admin_note', sanitize_textarea_field($_POST['admin_note']));
    }
}





add_action('admin_menu', 'custom_admin_menu');
function custom_admin_menu() {
    add_menu_page(
        'Sicofix Users',
        'Sicofix Users',
        'manage_options',
        'edit_user_page',
        'custom_admin_user_page',
        'dashicons-admin-users',
        6
    );
}

function custom_admin_user_page() {
    if (isset($_GET['user_id'])) {
        $user_id = intval($_GET['user_id']);
        $user = get_user_by('id', $user_id);

        if ($user) {
            if ($_SERVER['REQUEST_METHOD'] === 'POST') {
                // Uzmi staru vrednost pre izmene
                $old_note = get_user_meta($user_id, 'admin_note', true);
                $new_note = sanitize_textarea_field($_POST['admin_note']);

                update_user_meta($user_id, 'admin_note', $new_note);
                update_user_meta($user_id, 'custom_url', sanitize_text_field($_POST['custom_url']));
                update_user_meta($user_id, 'custom_user', sanitize_text_field($_POST['custom_user']));

                if (!empty($_POST['custom_pass'])) {
                    $encrypted_pass = encrypt_password(sanitize_text_field($_POST['custom_pass']));
                    update_user_meta($user_id, 'custom_pass', $encrypted_pass);
                }

                // Ako je napomena izmenjena, šalji email korisniku
                if ($old_note !== $new_note) {
                    $to = $user->user_email;
                    $subject = 'Nova poruka od administratora';
                    $message = "Pozdrav " . $user->first_name . ",\n\n";
                    $message .= "Administrator je ažurirao napomenu za tvoj nalog:\n\n";
                    $message .= $new_note . "\n\n";
                    $message .= "Možeš je pogledati na svom nalogu.\n";
                    $headers = ['Content-Type: text/plain; charset=UTF-8'];

                    wp_mail($to, $subject, $message, $headers);
                    error_log("📧 Poslat mejl korisniku: $to");
                }

                echo '<div class="updated"><p>Podaci su uspešno ažurirani.</p></div>';
            }
                    $encrypted_pass = get_user_meta($user_id, 'custom_pass', true);
                    $decrypted_pass = $encrypted_pass ? decrypt_password($encrypted_pass) : '';
            ?>
            <div class="wrap">
                <h1>Uredi korisnika: <?php echo esc_html($user->user_login); ?></h1>
                
                <form method="post">
                    <table class="form-table">
                        <tr>
                            <th><label for="admin_note">Admin Note</label></th>
                            <td><textarea name="admin_note" id="admin_note" class="regular-text"><?php echo esc_textarea(get_user_meta($user_id, 'admin_note', true)); ?></textarea></td>
                        </tr>
                        <tr>
                            <th><label for="custom_url">Hosting Provider URL:</label></th>
                            <td><input type="url" name="custom_url" id="custom_url" class="regular-text" value="<?php echo esc_attr(get_user_meta($user_id, 'custom_url', true)); ?>"></td>
                        </tr>
                        <tr>
                            <th><label for="custom_user">Username/Email/Customer ID:</label></th>
                            <td><input type="text" name="custom_user" id="custom_user" class="regular-text" value="<?php echo esc_attr(get_user_meta($user_id, 'custom_user', true)); ?>"></td>
                        </tr>
                        <tr>
    <th><label for="custom_pass">Password:</label></th>
    <td>
        <input type="password" name="custom_pass" id="custom_pass" class="regular-text" value="<?php echo esc_attr($decrypted_pass); ?>">
        <button type="button" onclick="togglePassword()" class="show-pass">Show</button>
    </td>
</tr>
                    </table>
                    <p class="submit">
                        <button type="submit" class="button button-primary">Save</button>
                    </p>
                </form>
                <hr>
            </div>
            <script>
function togglePassword() {
    var passInput = document.getElementById('custom_pass');
    if (passInput.type === "password") {
        passInput.type = "text";
    } else {
        passInput.type = "password";
    }
}
</script>

            <?php
        } else {
            echo '<div class="error"><p>Korisnik nije pronađen.</p></div>';
        }
    }

    // Zatim prikazujemo listu svih korisnika
    ?>
    <div class="wrap">
        <h2>Lista korisnika</h2>
        <table class="widefat fixed striped">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Username</th>
                    <th>Email</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $users = get_users();
                foreach ($users as $user) {
                    $edit_url = admin_url('admin.php?page=edit_user_page&user_id=' . $user->ID);
                    echo '<tr>';
                    echo '<td>' . esc_html($user->ID) . '</td>';
                    echo '<td>' . esc_html($user->user_login) . '</td>';
                    echo '<td>' . esc_html($user->user_email) . '</td>';
                    echo '<td><a href="' . esc_url($edit_url) . '" class="button">Uredi</a></td>';
                    echo '</tr>';
                }
                ?>
            </tbody>
        </table>
    </div>
    <?php
}




add_filter('woocommerce_account_menu_items', 'dodaj_ticket_tab');
function dodaj_ticket_tab($items) {
    $items['support-tickets'] = 'Tickets';
    return $items;
}

add_action('init', function() {
    add_rewrite_endpoint('support-tickets', EP_ROOT | EP_PAGES);
});

// Obrada POST zahteva se seli u template_redirect
add_action('template_redirect', function() {
    if (is_user_logged_in() && is_account_page()) {
        $current_user_id = get_current_user_id();

        // Novi tiket
        if (isset($_POST['new_ticket_submit']) && !empty($_POST['ticket_subject']) && !empty($_POST['ticket_message'])) {
            $ticket_id = wp_insert_post([
                'post_title' => sanitize_text_field($_POST['ticket_subject']),
                'post_type' => 'support_ticket',
                'post_status' => 'publish',
                'post_author' => $current_user_id,
            ]);

            if ($ticket_id) {
                wp_insert_comment([
                    'comment_post_ID' => $ticket_id,
                    'comment_content' => sanitize_textarea_field($_POST['ticket_message']),
                    'user_id' => $current_user_id,
                ]);
                send_ticket_creation_email($ticket_id);
                wp_redirect(wc_get_account_endpoint_url('support-tickets') . '?created=1');
                exit;
            }
        }

        // Odgovor na tiket
        if (isset($_POST['ticket_reply_submit'], $_POST['ticket_reply_id'], $_POST['ticket_reply'])) {
            $ticket_id = intval($_POST['ticket_reply_id']);
             $comment_content = sanitize_textarea_field($_POST['ticket_reply']);
            $ticket = get_post($ticket_id);
            if ($ticket && $ticket->post_type === 'support_ticket' && $ticket->post_author == $current_user_id) {
                wp_insert_comment([
                    'comment_post_ID' => $ticket_id,
                    'comment_content' => sanitize_textarea_field($_POST['ticket_reply']),
                    'user_id' => $current_user_id,
                ]);
                send_ticket_user_reply_email($ticket_id,$comment_content);
                wp_redirect(wc_get_account_endpoint_url('support-tickets') . '?replied=1');
                 
                exit;
            }
        }
    }
});


add_action('woocommerce_account_support-tickets_endpoint', 'prikazi_ticket_sadrzaj');
function prikazi_ticket_sadrzaj() {
    $current_user_id = get_current_user_id();
    
       // Forma za novi tiket
    if (isset($_POST['new_ticket_submit']) && !empty($_POST['ticket_subject']) && !empty($_POST['ticket_message'])) {
        $ticket_id = wp_insert_post([
            'post_title' => sanitize_text_field($_POST['ticket_subject']),
            'post_type' => 'support_ticket',
            'post_status' => 'publish',
            'post_author' => $current_user_id,
        ]);



        
        
        
        if ($ticket_id) {
            wp_insert_comment([
                'comment_post_ID' => $ticket_id,
                'comment_content' => sanitize_textarea_field($_POST['ticket_message']),
                'user_id' => $current_user_id,
            ]);
            
              
              
           
            
            
            echo '<div class="woocommerce-message">Ticket je kreiran.</div>';
        }
    }

    

    if (isset($_GET['created'])) {
        
        echo '<div class="woocommerce-message">Ticket je kreiran.</div>';
        
    }

    if (isset($_GET['replied'])) {
        echo '<div class="woocommerce-message">Odgovor je dodat.</div>';
    }

 

    ?>
     <!-- Forma -->
    <h3 class="ticket-h3">Create new ticket</h3>
    <form method="post" class="ticket-form">
        <p><label for="ticket_subject">Subject</label><br>
        <input type="text" name="ticket_subject" id="ticket_subject" required></p>
        <p><label for="ticket_message">Message</label><br>
        <textarea name="ticket_message" id="ticket_message" rows="5" required></textarea></p>
        <p><button type="submit" name="new_ticket_submit" class="ticket-button">Send</button></p>
    </form>
    <hr>
    <br>
    <h3 class="ticket-h3">My Tickets</h3>
    <br>
    <?php
    $args = [
        'post_type' => 'support_ticket',
        'author' => $current_user_id,
        'posts_per_page' => -1,
        'orderby' => 'date',
        'order' => 'DESC',
    ];
    $tickets = get_posts($args);
    if ($tickets) {
        foreach ($tickets as $ticket) {
            echo '<div class="ticket-box-o" >';
            echo '<p class="naslov-tiketa">' . esc_html($ticket->post_title) . '</p>';
            $comments = get_comments(['post_id' => $ticket->ID, 'orderby' => 'comment_date_gmt', 'order' => 'ASC']);
            foreach ($comments as $comment) {
                $author = get_userdata($comment->user_id);
                echo '<p class="poruka"><strong>' . esc_html($author->display_name) . ':</strong> ' . esc_html($comment->comment_content) . '</p>';
            }
            ?>
            <form method="post">
                <input type="hidden" name="ticket_reply_id" value="<?php echo esc_attr($ticket->ID); ?>">
                <textarea name="ticket_reply" rows="3" class="box-odgovor" placeholder="Message..." required></textarea>
                <button type="submit" name="ticket_reply_submit" class="ticket-button">Reply</button>
            </form>
            <?php
            echo '</div>';
        }
    } else {
        echo '<p>Nemate nijedan ticket.</p>';
    }
}

function send_ticket_creation_email($ticket_id) {
    // Preuzmi informacije o tiketu
    $ticket = get_post($ticket_id);
    $ticket_title = $ticket->post_title;
    $ticket_author_id = $ticket->post_author;
    $ticket_author = get_userdata($ticket_author_id);
    $ticket_author_email = $ticket_author->user_email;
    
    // Email koji ćeš poslati administratoru
    $admin_email = get_option('admin_email'); // Email administratora
    
    $subject = 'Novi tiket kreiran: ' . $ticket_title;
    $message = 'Pozdrav Administratoru,' . "\n\n";
    $message .= 'Kreiran je novi tiket.' . "\n\n";
    $message .= 'Naslov tiketa: ' . $ticket_title . "\n";
    $message .= 'Korisnik: ' . $ticket_author->display_name . "\n";
    $message .= 'Email korisnika: ' . $ticket_author_email . "\n\n";
    $message .= 'Možete pregledati tiket u admin panelu.' . "\n";
    
    $headers = array('Content-Type: text/plain; charset=UTF-8');
    
    // Pošaljite email administratoru
    wp_mail($admin_email, $subject, $message, $headers);
}

function send_ticket_user_reply_email($ticket_id, $comment_content) {
    // Preuzmi informacije o tiketu
    $ticket = get_post($ticket_id);
    $ticket_title = $ticket->post_title;
    $ticket_author_id = $ticket->post_author;
    $ticket_author = get_userdata($ticket_author_id);
    $ticket_author_email = $ticket_author->user_email;
    
    // Email koji ćeš poslati administratoru
    $admin_email = get_option('admin_email'); // Email administratora
    
    $subject = 'Novi odgovor na tiketu: ' . $ticket_title;
    $message = 'Pozdrav Administratoru,' . "\n\n";
    $message .= 'Kreiran je novi odgovor.' . "\n\n";
    $message .= 'Novi odgovor: '   . nl2br(sanitize_textarea_field($comment_content));
    $headers = ['Content-Type: text/plain; charset=UTF-8'];
    
    // Pošaljite email administratoru
    wp_mail($admin_email, $subject, $message, $headers);
}


add_action('init', 'registruj_ticket_post_type');
function registruj_ticket_post_type() {
    register_post_type('support_ticket', [
        'labels' => [
            'name' => 'Tickets',
            'singular_name' => 'Ticket',
        ],
        'public' => false,
        'has_archive' => false,
        'show_ui' => true,
        'capability_type' => 'post',
        'supports' => ['title'],
        'rewrite' => false,
    ]);
}


add_action('admin_menu', 'custom_support_tickets_menu');

function custom_support_tickets_menu() {
    add_menu_page(
        'Support Tickets',
        'Support Tickets',
        'manage_options',
        'custom-support-tickets',
        'render_support_tickets_admin_page',
        'dashicons-format-chat',
        6
    );
}


function render_support_tickets_admin_page() {
    $args = array(
        'post_type' => 'support_ticket',
        'post_status' => 'publish',
        'posts_per_page' => 20
    );
    $tickets = get_posts($args);

    echo '<div class="wrap"><h1>Support Ticketi</h1>';

    if (isset($_GET['ticket_id'])) {
        $ticket_id = intval($_GET['ticket_id']);
        $ticket = get_post($ticket_id);
        if ($ticket) {
            echo '<h2>' . esc_html($ticket->post_title) . '</h2>';
            echo '<p>' . esc_html($ticket->post_content) . '</p>';
            
            $comments = get_comments([
    'post_id' => $ticket_id,
    'order' => 'ASC',
    'orderby' => 'comment_date_gmt'
]);


            // echo '<h3>Content</h3>';
            echo '<ul>';
            foreach ($comments as $comment) {
                 $author = get_userdata($comment->user_id);
                echo '<li><strong>' . esc_html($author->display_name) . ':</strong> ' . esc_html($comment->comment_content) . '</li>';
            }
            echo '</ul>';

            // Forma za odgovor
            echo '<h3>Reply</h3>';
            echo '<form method="post">';
            wp_nonce_field('admin_reply_ticket');
            echo '<textarea name="admin_reply" rows="5" style="width:100%;"></textarea><br>';
            echo '<input type="hidden" name="ticket_id" value="' . esc_attr($ticket_id) . '">';
            submit_button('Reply');
            echo '</form>';

            if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['admin_reply']) && check_admin_referer('admin_reply_ticket')) {
                wp_insert_comment([
                    'comment_post_ID' => $ticket_id,
                    'comment_content' => wp_kses_post($_POST['admin_reply']),
                    'user_id' => get_current_user_id(),
                    'comment_author' => 'Admin',
                    'comment_approved' => 1,
                ]);
                
                send_ticket_reply_email($ticket_id, $_POST['admin_reply']);
                
                echo '<div class="updated"><p>Reply added.</p></div>';
                echo '<script>location.reload();</script>';
            }

            echo '<p><a href="' . admin_url('admin.php?page=custom-support-tickets') . '">Back to the List</a></p>';
        }
    } else {
        echo '<table class="wp-list-table widefat fixed striped">';
        echo '<thead><tr><th>ID</th><th>Subject</th><th>User</th><th>Actions</th></tr></thead><tbody>';
        foreach ($tickets as $ticket) {
            $user_id = $ticket->post_author;
            $user_info = get_userdata($user_id);
            echo '<tr>';
            echo '<td>' . esc_html($ticket->ID) . '</td>';
            echo '<td>' . esc_html($ticket->post_title) . '</td>';
            echo '<td>' . esc_html($user_info ? $user_info->user_login : 'Nepoznat') . '</td>';
            echo '<td><a href="' . admin_url('admin.php?page=custom-support-tickets&ticket_id=' . $ticket->ID) . '">Open</a></td>';
            echo '</tr>';
        }
        echo '</tbody></table>';
    }

    echo '</div>';
}
function send_ticket_reply_email($ticket_id, $comment_content) {
    $user_id = get_post_field('post_author', $ticket_id);
    $user = get_userdata($user_id);

    if (!$user) return;

    $ticket_title = get_the_title($ticket_id);

    $to = $user->user_email;
    $subject = 'Novi odgovor na vaš tiket: ' . $ticket_title;
    $message = 'Administrator je odgovorio na vaš tiket: <br><br>' . nl2br(sanitize_textarea_field($comment_content));
    $headers = ['Content-Type: text/html; charset=UTF-8'];

    wp_mail($to, $subject, $message, $headers);
}

// Pozovi ovu funkciju kad se komentar doda
add_action('comment_post', 'ticket_reply_email', 10, 2);

function ticket_reply_email($comment_id, $comment_approved) {
    if ($comment_approved) {
        $comment = get_comment($comment_id);
        $ticket_id = $comment->comment_post_ID; // povezivanje sa ticket ID

        // Pozivanje funkcije za slanje email-a
        send_ticket_reply_email($ticket_id, $comment->comment_content);
    }
}

