<?php

// Dodaj custom polja za min, max i step
add_action( 'woocommerce_product_options_general_product_data', 'custom_quantity_fields' );
function custom_quantity_fields() {
    woocommerce_wp_text_input( array(
        'id'          => '_custom_min_qty',
        'label'       => 'Min',
        'desc_tip'    => 'true',
        'description' => 'Unesi minimalnu količinu za narudžbinu.',
        'type'        => 'number',
        'custom_attributes' => array(
            'min' => '1',
            'step' => '1',
        )
    ));

    woocommerce_wp_text_input( array(
        'id'          => '_custom_max_qty',
        'label'       => 'Max',
        'desc_tip'    => 'true',
        'description' => 'Unesi maksimalnu količinu za narudžbinu.',
        'type'        => 'number',
        'custom_attributes' => array(
            'min' => '1',
            'step' => '1',
        )
    ));

    woocommerce_wp_text_input( array(
        'id'          => '_custom_step_qty',
        'label'       => 'Step',
        'desc_tip'    => 'true',
        'description' => 'Unesi korak količine (npr. 2, 5 itd).',
        'type'        => 'number',
        'custom_attributes' => array(
            'min' => '1',
            'step' => '1',
        )
    ));
}

add_action( 'woocommerce_process_product_meta', 'save_custom_quantity_fields' );


function save_custom_quantity_fields( $post_id ) {
    if ( isset( $_POST['_custom_min_qty'] ) ) {
        update_post_meta( $post_id, '_custom_min_qty', sanitize_text_field( $_POST['_custom_min_qty'] ) );
    }
    if ( isset( $_POST['_custom_max_qty'] ) ) {
        update_post_meta( $post_id, '_custom_max_qty', sanitize_text_field( $_POST['_custom_max_qty'] ) );
    }
    if ( isset( $_POST['_custom_step_qty'] ) ) {
        update_post_meta( $post_id, '_custom_step_qty', sanitize_text_field( $_POST['_custom_step_qty'] ) );
    }
}

add_filter( 'woocommerce_quantity_input_args', 'apply_custom_quantity_fields', 10, 2 );

function apply_custom_quantity_fields( $args, $product ) {
    $min = get_post_meta( $product->get_id(), '_custom_min_qty', true );
    $max = get_post_meta( $product->get_id(), '_custom_max_qty', true );
    $step = get_post_meta( $product->get_id(), '_custom_step_qty', true );

    if ( $min !== '' ) {
        $args['min_value'] = (int) $min;
    }
    if ( $max !== '' ) {
        $args['max_value'] = (int) $max;
    }
    if ( $step !== '' ) {
        $args['step'] = (int) $step;
    }

    return $args;
}

?>